<?php
/**
 * Defines the fallback values for the informational modules.
 *
 * To remove the keys on info modules custom palette
 * and use fallback palletes color.
 *
 * @package Hustle
 */

return array(

	// ==================================================|
	// 4. INPUTS                                         |
	// ==================================================|

	// ***************************************************
	// 4.1. DEFAULT

	// Icon color.
	'optin_input_icon'                   => '#AAAAAA',

	// Background color.
	'optin_input_static_bg'              => '#FFFFFF',

	// Border color.
	'optin_input_static_bo'              => '#FFFFFF',

	// Text color.
	'optin_form_field_text_static_color' => '#4D95B6',

	// Placeholder color.
	'optin_placeholder_color'            => '#AAAAAA',

	// ***************************************************
	// 4.2. HOVER

	// Icon color.
	'optin_input_icon_hover'             => '#5D7380',

	// Background color.
	'optin_input_hover_bg'               => '#FFFFFF',

	// Border color.
	'optin_input_hover_bo'               => '#FFFFFF',

	// ***************************************************
	// 4.3. FOCUS

	// Icon color.
	'optin_input_icon_focus'             => '#5D7380',

	// Background color.
	'optin_input_active_bg'              => '#FFFFFF',

	// Border color.
	'optin_input_active_bo'              => '#FFFFFF',

	// ***************************************************
	// 4.4. ERROR

	// Icon color.
	'optin_input_icon_error'             => '#D43858',

	// Border color.
	'optin_input_error_border'           => '#D43858',

	// Background color.
	'optin_input_error_background'       => '#FFFFFF',


	// ==================================================|
	// 5. RADIO AND CHECKBOX                             |
	// ==================================================|

	// ***************************************************
	// 5.1. DEFAULT

	// Border color.
	'optin_check_radio_bo'               => '#FFFFFF',

	// Background color.
	'optin_check_radio_bg'               => '#FFFFFF',

	// Label color.
	'optin_mailchimp_labels_color'       => '#FFFFFF',

	// ***************************************************
	// 5.2. CHECKED

	// Border color.
	'optin_check_radio_bo_checked'       => '#FFFFFF',

	// Background color.
	'optin_check_radio_bg_checked'       => '#FFFFFF',

	// Icon color.
	'optin_check_radio_tick_color'       => '#78B5D1',

	// ==================================================|
	// 6. GDPR CHECKBOX                                  |
	// ==================================================|

	// ***************************************************
	// 6.1. DEFAULT

	// Border color.
	'gdpr_chechbox_border_static'        => '#FFFFFF',

	// Background color.
	'gdpr_chechbox_background_static'    => '#FFFFFF',

	// Label color.
	'gdpr_content'                       => '#FFFFFF',

	// Label link color.
	'gdpr_content_link'                  => '#FFFFFF',

	// ***************************************************
	// 6.2. CHECKED

	// Border color.
	'gdpr_chechbox_border_active'        => '#FFFFFF',

	// Background color.
	'gdpr_checkbox_background_active'    => '#FFFFFF',

	// Icon color.
	'gdpr_checkbox_icon'                 => '#78B5D1',

	// ***************************************************
	// 6.3. ERROR

	// Border color.
	'gdpr_checkbox_border_error'         => '#D43858',

	// Background color.
	'gdpr_checkbox_background_error'     => '#FFFFFF',

	// ==================================================|
	// 6. SELECT                                         |
	// ==================================================|

	// ***************************************************
	// 6.1. DEFAULT

	// Select Border color.
	'optin_select_border'                => '#FFFFFF',

	// Icon color.
	'optin_select_icon'                  => '#4D95B6',

	// Background color.
	'optin_select_background'            => '#FFFFFF',

	// Placeholder color.
	'optin_select_placeholder'           => '#AAAAAA',

	// Label color.
	'optin_select_label'                 => '#4D95B6',

	// ***************************************************
	// 6.2. HOVER

	// Border color.
	'optin_select_border_hover'          => '#FFFFFF',

	// Icon color.
	'optin_select_icon_hover'            => '#165E80',

	// Background color.
	'optin_select_background_hover'      => '#FFFFFF',

	// ***************************************************
	// 6.3. OPEN

	// Border color.
	'optin_select_border_open'           => '#FFFFFF',

	// Icon color.
	'optin_select_icon_open'             => '#165E80',

	// Background color.
	'optin_select_background_open'       => '#FFFFFF',

	// ***************************************************
	// 6.4. ERROR

	// Border color.
	'optin_select_border_error'          => '#D43858',

	// Icon color.
	'optin_select_icon_error'            => '#D43858',

	// Background color.
	'optin_select_background_error'      => '#FFFFFF',

	// ==================================================|
	// 7. DROPDOWN                                       |
	// ==================================================|

	// ***************************************************
	// 7.1. DEFAULT

	// Container BG.
	'optin_dropdown_background'          => '#FFFFFF',

	// Label color.
	'optin_dropdown_option_color'        => '#78B5D1',

	// ***************************************************
	// 7.2. HOVER

	// Label color.
	'optin_dropdown_option_color_hover'  => '#FFFFFF',

	// Background color.
	'optin_dropdown_option_bg_hover'     => '#AAAAAA',

	// ***************************************************
	// 7.3. SELECTED

	// Label color.
	'optin_dropdown_option_color_active' => '#FFFFFF',

	// Background color.
	'optin_dropdown_option_bg_active'    => '#4D95B6',

	// ==================================================|
	// 8. CALENDAR                                       |
	// ==================================================|

	// ***************************************************
	// 8.1. DEFAULT

	// Container BG.
	'optin_calendar_background'          => '#FFFFFF',

	// Title color.
	'optin_calendar_title'               => '#165E80',

	// Navigation arrows.
	'optin_calendar_arrows'              => '#165E80',

	// Table head color.
	'optin_calendar_thead'               => '#35414A',

	// Table cell background.
	'optin_calendar_cell_background'     => '#FFFFFF',

	// Table cell color.
	'optin_calendar_cell_color'          => '#5D7380',

	// ***************************************************
	// 8.2. HOVER

	// Navigation arrows.
	'optin_calendar_arrows_hover'        => '#165E80',

	// Table cell background.
	'optin_calendar_cell_bg_hover'       => '#4D95B6',

	// Table cell color.
	'optin_calendar_cell_color_hover'    => '#FFFFFF',

	// ***************************************************
	// 8.3. ACTIVE

	// Navigation arrows.
	'optin_calendar_arrows_active'       => '#165E80',

	// Table cell background.
	'optin_calendar_cell_bg_active'      => '#4D95B6',

	// Table cell color.
	'optin_calendar_cell_color_active'   => '#FFFFFF',

	// ==================================================|
	// 9. SUBMIT BUTTON                                  |
	// ==================================================|

	// ***************************************************
	// 9.1. DEFAULT

	// Border color.
	'optin_submit_button_static_bo'      => '#4D95B6',

	// Background color.
	'optin_submit_button_static_bg'      => '#4D95B6',

	// Label color.
	'optin_submit_button_static_color'   => '#FFFFFF',

	// ***************************************************
	// 9.2. HOVER

	// Border color.
	'optin_submit_button_hover_bo'       => '#165E80',

	// Background color.
	'optin_submit_button_hover_bg'       => '#165E80',

	// Label color.
	'optin_submit_button_hover_color'    => '#FFFFFF',

	// ***************************************************
	// 9.3. ACTIVE

	// Border color.
	'optin_submit_button_active_bo'      => '#165E80',

	// Background color.
	'optin_submit_button_active_bg'      => '#165E80',

	// Label color.
	'optin_submit_button_active_color'   => '#FFFFFF',

	// ==================================================|
	// 10. CUSTOM FIELDS SECTION                         |
	// ==================================================|

	// Title color.
	'optin_mailchimp_title_color'        => '#FFFFFF',

	// Container background.
	'custom_section_bg'                  => '#165E80',

	// ==================================================|
	// 11. ERROR MESSAGE                                 |
	// ==================================================|

	// Background color.
	'optin_error_text_bg'                => '#FFFFFF',

	// Border color.
	'optin_error_text_border'            => '#D43858',

	// Message color.
	'optin_error_text_color'             => '#D43858',

	// ==================================================|
	// 12. SUCCESS MESSAGE                               |
	// ==================================================|

	// Background color.
	'optin_success_background'           => '#176387',

	// Icon color.
	'optin_success_tick_color'           => '#4D95B6',

	// Content color.
	'optin_success_content_color'        => '#FFFFFF',

	// New colors settings to adjust and re-arrange.
	'module_cont_drop_shadow'            => 'rgba(0,0,0,0)',
	'module_cont_border'                 => '#DADADA',

	'layout_content_border'              => 'rgba(0,0,0,0)',
	'layout_content_bg'                  => 'rgba(0,0,0,0)',
	'layout_content_drop_shadow'         => 'rgba(0,0,0,0)',

	'form_cont_border'                   => 'rgba(0,0,0,0)',
	'form_cont_drop_shadow'              => 'rgba(0,0,0,0)',

	'title_drop_shadow'                  => 'rgba(0,0,0,0)',
	'title_border'                       => 'rgba(0,0,0,0)',
	'title_bg'                           => 'rgba(0,0,0,0)',

	'subtitle_drop_shadow'               => 'rgba(0,0,0,0)',
	'subtitle_border'                    => 'rgba(0,0,0,0)',
	'subtitle_bg'                        => 'rgba(0,0,0,0)',

	'content_wrap_border'                => 'rgba(0,0,0,0)',
	'content_wrap_bg'                    => 'rgba(0,0,0,0)',
	'content_wrap_drop_shadow'           => 'rgba(0,0,0,0)',

	'cta_button_static_drop_shadow'      => 'rgba(0,0,0,0)',
	'cta_button_hover_drop_shadow'       => 'rgba(0,0,0,0)',
	'cta_button_active_drop_shadow'      => 'rgba(0,0,0,0)',

	'form_extras_border'                 => 'rgba(0,0,0,0)',
	'form_extras_drop_shadow'            => 'rgba(0,0,0,0)',

	'optin_input_drop_shadow'            => 'rgba(0,0,0,0)',

	'optin_dropdown_border'              => '#FFFFFF',
	'optin_dropdown_drop_shadow'         => 'rgba(0,0,0,0)',

	'optin_success_border'               => 'rgba(0,0,0,0)',
	'optin_success_drop_shadow'          => 'rgba(0,0,0,0)',

	'submit_button_static_drop_shadow'   => 'rgba(0,0,0,0)',

	'recaptcha_copy_border'              => 'rgba(0,0,0,0)',
	'recaptcha_copy_drop_shadow'         => 'rgba(0,0,0,0)',

	'content_border'                     => 'rgba(0,0,0,0)',
	'cta_cont_border'                    => 'rgba(0,0,0,0)',
);
